% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autonewsmd.R
\name{autonewsmd}
\alias{autonewsmd}
\title{R6 Class to construct the changelog file}
\description{
The `autonewsmd` class is used to construct a new changelog file, set all
  required metadata and to generate the file and save it to the root-
  directory of the respective repository.
}
\details{
The changelog file has a title that typically includes the name of the
  repository, which needs at least to be provided when constructing a new
  changelog file.
}
\examples{
# (Example is based on the public examples from the `git2r` R package)
## Initialize a repository
path <- file.path(tempdir(), "autonewsmd")
dir.create(path)
repo <- git2r::init(path)

## Config user
git2r::config(repo, user.name = "Alice", user.email = "alice@example.org")
git2r::remote_set_url(repo, "foobar", "https://example.org/git2r/foobar")


## Write to a file and commit
lines <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
writeLines(lines, file.path(path, "example.txt"))

git2r::add(repo, "example.txt")
git2r::commit(repo, "feat: new file")

## Write again to a file and commit
lines2 <- paste0(
  "eiusmod tempor incididunt ut labore et dolore magna aliqua. ",
  "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris ",
  "nisi ut aliquip ex ea commodo consequat."
)
write(lines2, file.path(path, "example.txt"), append = TRUE)

git2r::add(repo, "example.txt")
git2r::commit(repo, "refactor: added second phrase")

## now construct a new autonewsmd object
an <- autonewsmd$new(repo_name = "TestRepo", repo_path = path)

## generate the news and write them to the repo
an$generate()

if (interactive()) {
  an$write()
}


## ------------------------------------------------
## Method `autonewsmd$new`
## ------------------------------------------------

# (Example is based on the public examples from the `git2r` R package)
## Initialize a repository
path <- file.path(tempdir(), "autonewsmd")
dir.create(path)
repo <- git2r::init(path)

## Config user
git2r::config(
  repo, user.name = "Alice", user.email = "alice@example.org"
)
git2r::remote_set_url(repo, "foobar", "https://example.org/git2r/foobar")


## Write to a file and commit
lines <- paste0(
  "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
)
writeLines(lines, file.path(path, "example.txt"))

git2r::add(repo, "example.txt")
git2r::commit(repo, "feat: new file")

## Write again to a file and commit
lines2 <- paste0(
  "eiusmod tempor incididunt ut labore et dolore magna aliqua. ",
  "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris ",
  "nisi ut aliquip ex ea commodo consequat."
)
write(lines2, file.path(path, "example.txt"), append = TRUE)

git2r::add(repo, "example.txt")
git2r::commit(repo, "refactor: added second phrase")

## now construct a new autonewsmd object
an <- autonewsmd$new(repo_name = "TestRepo", repo_path = path)


## ------------------------------------------------
## Method `autonewsmd$generate`
## ------------------------------------------------

# (Example is based on the public examples from the `git2r` R package)
## Initialize a repository
path <- file.path(tempdir(), "autonewsmd")
dir.create(path)
repo <- git2r::init(path)

## Config user
git2r::config(
  repo, user.name = "Alice", user.email = "alice@example.org"
)
git2r::remote_set_url(repo, "foobar", "https://example.org/git2r/foobar")


## Write to a file and commit
lines <- paste0(
  "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
)
writeLines(lines, file.path(path, "example.txt"))

git2r::add(repo, "example.txt")
git2r::commit(repo, "feat: new file")

## Write again to a file and commit
lines2 <- paste0(
  "eiusmod tempor incididunt ut labore et dolore magna aliqua. ",
  "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris ",
  "nisi ut aliquip ex ea commodo consequat."
)
write(lines2, file.path(path, "example.txt"), append = TRUE)

git2r::add(repo, "example.txt")
git2r::commit(repo, "refactor: added second phrase")

## now construct a new autonewsmd object
an <- autonewsmd$new(repo_name = "TestRepo", repo_path = path)

## generate the news and write them to the repo
an$generate()


## ------------------------------------------------
## Method `autonewsmd$write`
## ------------------------------------------------

# (Example is based on the public examples from the `git2r` R package)
## Initialize a repository
path <- tempdir()
repo <- git2r::init(path)

## Config user
git2r::config(
  repo, user.name = "Alice", user.email = "alice@example.org"
)
git2r::remote_set_url(repo, "foobar", "https://example.org/git2r/foobar")


## Write to a file and commit
lines <- paste0(
  "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
)
writeLines(lines, file.path(path, "example.txt"))

git2r::add(repo, "example.txt")
git2r::commit(repo, "feat: new file")

## Write again to a file and commit
lines2 <- paste0(
  "eiusmod tempor incididunt ut labore et dolore magna aliqua. ",
  "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris ",
  "nisi ut aliquip ex ea commodo consequat."
)
write(lines2, file.path(path, "example.txt"), append = TRUE)

git2r::add(repo, "example.txt")
git2r::commit(repo, "refactor: added second phrase")

## now construct a new autonewsmd object
an <- autonewsmd$new(repo_name = "TestRepo", repo_path = path)

## generate the news and write them to the repo
an$generate()

if (interactive()) {
  an$write()
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{repo_name}}{A character. The name of the repository, which is
inserted into the title of the changelog file.}

\item{\code{tag_pattern}}{A character. A regular expression pattern to identify
release tags in the repository.
Defaults to `"^v(\\d+\\.){2}\\d+(\\.\\d+)?$"` to identify patterns of
the from `v0.0.1.9001`.}

\item{\code{repo_list}}{The list contains the commit messages prepared for
the changelog file.}

\item{\code{file_name}}{A character. The name of the file, which is
inserted into the title of the changelog file. Defaults to `"NEWS"`
(typically one of `"NEWS"` or `"CHANGELOG"`).}

\item{\code{file_ending}}{A character. The file ending of the file the
changelog should be written to. Defaults to `".md"`.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-autonewsmd-new}{\code{autonewsmd$new()}}
\item \href{#method-autonewsmd-generate}{\code{autonewsmd$generate()}}
\item \href{#method-autonewsmd-write}{\code{autonewsmd$write()}}
\item \href{#method-autonewsmd-clone}{\code{autonewsmd$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-autonewsmd-new"></a>}}
\if{latex}{\out{\hypertarget{method-autonewsmd-new}{}}}
\subsection{Method \code{new()}}{
Create a new `autonewsmd` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{autonewsmd$new(repo_name, repo_path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{repo_name}}{A character. The name of the repository, which is
inserted into the title of the changelog file.}

\item{\code{repo_path}}{A character. The path of the repository to create a new
changelog for. If `NULL` (the default), it will point automatically to
to `"."`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `autonewsmd` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# (Example is based on the public examples from the `git2r` R package)
## Initialize a repository
path <- file.path(tempdir(), "autonewsmd")
dir.create(path)
repo <- git2r::init(path)

## Config user
git2r::config(
  repo, user.name = "Alice", user.email = "alice@example.org"
)
git2r::remote_set_url(repo, "foobar", "https://example.org/git2r/foobar")


## Write to a file and commit
lines <- paste0(
  "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
)
writeLines(lines, file.path(path, "example.txt"))

git2r::add(repo, "example.txt")
git2r::commit(repo, "feat: new file")

## Write again to a file and commit
lines2 <- paste0(
  "eiusmod tempor incididunt ut labore et dolore magna aliqua. ",
  "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris ",
  "nisi ut aliquip ex ea commodo consequat."
)
write(lines2, file.path(path, "example.txt"), append = TRUE)

git2r::add(repo, "example.txt")
git2r::commit(repo, "refactor: added second phrase")

## now construct a new autonewsmd object
an <- autonewsmd$new(repo_name = "TestRepo", repo_path = path)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-autonewsmd-generate"></a>}}
\if{latex}{\out{\hypertarget{method-autonewsmd-generate}{}}}
\subsection{Method \code{generate()}}{
Generate the list with the formatted commit messages that is used to
  render the changelog.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{autonewsmd$generate()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The function generates the formatted list with the commit
  messages. If tags are available, each commit message is assigned to a
  specific tag. These assignments are used to structure the changelog
  document.
}

\subsection{Returns}{
Populates the public field `repo_list`.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# (Example is based on the public examples from the `git2r` R package)
## Initialize a repository
path <- file.path(tempdir(), "autonewsmd")
dir.create(path)
repo <- git2r::init(path)

## Config user
git2r::config(
  repo, user.name = "Alice", user.email = "alice@example.org"
)
git2r::remote_set_url(repo, "foobar", "https://example.org/git2r/foobar")


## Write to a file and commit
lines <- paste0(
  "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
)
writeLines(lines, file.path(path, "example.txt"))

git2r::add(repo, "example.txt")
git2r::commit(repo, "feat: new file")

## Write again to a file and commit
lines2 <- paste0(
  "eiusmod tempor incididunt ut labore et dolore magna aliqua. ",
  "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris ",
  "nisi ut aliquip ex ea commodo consequat."
)
write(lines2, file.path(path, "example.txt"), append = TRUE)

git2r::add(repo, "example.txt")
git2r::commit(repo, "refactor: added second phrase")

## now construct a new autonewsmd object
an <- autonewsmd$new(repo_name = "TestRepo", repo_path = path)

## generate the news and write them to the repo
an$generate()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-autonewsmd-write"></a>}}
\if{latex}{\out{\hypertarget{method-autonewsmd-write}{}}}
\subsection{Method \code{write()}}{
Writes the changelog to the file system.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{autonewsmd$write(force = FALSE, con = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{A boolean. If `FALSE` (the default) a dialog is prompted to
ask the user if the file should be (over-) written. If `TRUE`, the
dialog is not prompted and the changelog file is created directly.}

\item{\code{con}}{A connection with the answer to the interactive question, if
the changelog file should be written to the file system. This argument
is intended mainly for being used in the unit tests.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function writes the changelog to the file system using the
  `file_name` and `file_ending` fields to compose the file name.
  CAUTION: existing files will be overwritten without any warning.
}

\subsection{Returns}{
The function has no return value - it creates the new changelog
  file.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# (Example is based on the public examples from the `git2r` R package)
## Initialize a repository
path <- tempdir()
repo <- git2r::init(path)

## Config user
git2r::config(
  repo, user.name = "Alice", user.email = "alice@example.org"
)
git2r::remote_set_url(repo, "foobar", "https://example.org/git2r/foobar")


## Write to a file and commit
lines <- paste0(
  "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
)
writeLines(lines, file.path(path, "example.txt"))

git2r::add(repo, "example.txt")
git2r::commit(repo, "feat: new file")

## Write again to a file and commit
lines2 <- paste0(
  "eiusmod tempor incididunt ut labore et dolore magna aliqua. ",
  "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris ",
  "nisi ut aliquip ex ea commodo consequat."
)
write(lines2, file.path(path, "example.txt"), append = TRUE)

git2r::add(repo, "example.txt")
git2r::commit(repo, "refactor: added second phrase")

## now construct a new autonewsmd object
an <- autonewsmd$new(repo_name = "TestRepo", repo_path = path)

## generate the news and write them to the repo
an$generate()

if (interactive()) {
  an$write()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-autonewsmd-clone"></a>}}
\if{latex}{\out{\hypertarget{method-autonewsmd-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{autonewsmd$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
