% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_functions_other.R
\name{autosize}
\alias{autosize}
\title{Automatically select plot matrix dimensions}
\usage{
autosize(n)
}
\arguments{
\item{n}{The number of plots.  Should be a positive integer.}
}
\value{
A vector of length 2 with the number of rows and number of 
  columns for the plot matrix.
}
\description{
\code{autosize} automatically makes a sensible choice for the 
dimensions of a plot matrix based on \code{n}, the number of plots.
Only works for \code{n <= 36}. The dimensions are chosen to be as 
close to a square as possible.
}
\examples{
autosize(3)
autosize(9)
autosize(11)
autosize(24)
}
