% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_one.R
\name{render_one}
\alias{render_one}
\title{Run a single Rmd file through autoharp.}
\usage{
render_one(
  rmd_name,
  out_dir,
  knit_root_dir,
  log_name,
  soln_stuff,
  max_time_per_run = 120,
  permission_to_install = FALSE
)
}
\arguments{
\item{rmd_name}{The path to the file to be rendered and checked.}

\item{out_dir}{The directory to store all the html output, md output, and
figures.}

\item{knit_root_dir}{The working directory while knitting the file.}

\item{log_name}{A character string, denoting the log file name. It defaults to
"render_one.log". If this file is already present in the directory, this
function will append to it.}

\item{soln_stuff}{This is a list, with components env, test_fname, and
tt_list. This object is the output of \code{\link{populate_soln_env}}. Set
this to be NA if you wish to skip correctness checks, and only do rendering.}

\item{max_time_per_run}{The maximum time to wait before aborting the
rendering of a particular file.}

\item{permission_to_install}{If TRUE, then the function will try to install 
any packages needed. By default, this is FALSE.}
}
\value{
A data frame with one row for each file in the input directory.
}
\description{
Renders the specified file, and collates run time, static and 
correctness checks.
}
\details{
The log file contains a record of the libraries used by the student, and if
any new libraries needed to be installed. The status will be one of SUCCESS,
FAIL or UNKNOWN.
}
\seealso{
\code{\link{populate_soln_env}}, \code{\link{check_correctness}}
}
