% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_migraph.R
\name{plot.network_test}
\alias{plot.network_test}
\title{Plotting methods for CUG and QAP tests}
\usage{
\method{plot}{network_test}(x, ..., threshold = 0.95, tails = c("two", "one"))
}
\arguments{
\item{x}{An object obtained from a conditional uniform graph or
quadratic assignment procedure test.
For example, \code{migraph::test_permutation()}.}

\item{...}{Other arguments to be passed on.}

\item{threshold}{The empirical threshold to shade in the plot.}

\item{tails}{By default "two" indicating a two-tailed test,
but "one" for a one-tailed test is also available.}
}
\value{
A distribution of the simulated or permuted statistics,
with 2.5\% shaded at each end, and a line highlighting where the observed
statistic lies on this distribution.
}
\description{
These plotting methods are for results obtained by testing some statistic
against those produced in a reference distribution of conditional uniform
graphs or as a quadratic assignment procedure.
The S3 class is "network_test".
}
\examples{
# Here's something I cooked up with migraph earlier:
plot(res_migraph_test)
}
