% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.r
\name{reduce.database_schema}
\alias{reduce.database_schema}
\title{Remove database schema relations not linked to the given relations}
\usage{
\method{reduce}{database_schema}(x, main, ...)
}
\arguments{
\item{x}{A database schema, whose relations are to be filtered.}

\item{main}{A character vector, containing names of relations to be
considered as the "main" relations.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A database schema, with the auxiliary relations and foreign key
references removed.
}
\description{
Filters a database schema's relations, keeping only the given relations, and
those considered ancestors via foreign key references. Foreign key
references involving removed relations are also removed.
}
\details{
This method takes a given set of main relations, rather than inferring them.

Using \code{\link{rejoin}} on the database resulting from decomposing a data
frame with the reduced schema is likely to fail or return incomplete results.
}
