% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxzphplot.R
\name{coxzphplot}
\alias{coxzphplot}
\title{Graphical Test of Proportional Hazards}
\usage{
coxzphplot(x, resid = TRUE, se = TRUE, var = NULL, hr = FALSE, add.lm = FALSE)
}
\arguments{
\item{x}{result of the cox.zph function.}

\item{resid}{a logical value, if TRUE the residuals are included on the plot, as well as the smooth fit.}

\item{se}{a logical value, if TRUE, confidence bands at two standard errors will be added.}

\item{var}{The set of variables for which plots are desired. It can be integer or variable names}

\item{hr}{logical If true, plot for hazard ratio, If false, plot for coefficients}

\item{add.lm}{logical If true, add linear regression line}
}
\value{
A facetted ggplot
}
\description{
Tis is a ggplot version of plot.cox.zph.
Displays a graph of the scaled Schoenfeld residuals, along with a smooth curve.
}
\examples{
library(survival)
vfit <- coxph(Surv(time,status) ~ trt + factor(celltype) + karno + age, data=veteran, x=TRUE)
x <- cox.zph(vfit)
coxzphplot(x)
coxzphplot(x,var="karno",add.lm=TRUE)
}
