% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSE_range.R
\name{RMSE_range}
\alias{RMSE_range}
\title{Calculate the Overall RMSE of the Trait Scores, or the RMSE in a Certain Trait Score Range}
\usage{
RMSE_range(true_scores, estimated_scores, range_breaks = NA)
}
\arguments{
\item{true_scores}{Actual trait scores}

\item{estimated_scores}{Estimated trait scores from a specified model}

\item{range_breaks}{A numeric vector. Specifies which trait scores ranges will the RMSE be calculated}
}
\value{
If \code{range_breaks} is not specified, an overall RMSE numeric value will be returned;
else, a named list showing the RMSE in each score range will be returned.
}
\description{
This function is also for diagnostic purposes, examining which interval on the
latent trait continuum does the FC scale demonstrate the best measurement accuracy.
}
\details{
TO BE DONE
}
\examples{
RMSE_range(rnorm(100), rnorm(100))
RMSE_range(rnorm(100), rnorm(100), range_breaks = c(-3, -2, -1, 0, 1, 2, 3))

}
\author{
Mengtong Li
}
