% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ets.R
\name{pfa.ets}
\alias{pfa.ets}
\title{PFA Formatting of Fitted Exponential Smoothing State Space Models}
\source{
pfa_config.R avro_typemap.R avro.R pfa_cellpool.R pfa_expr.R pfa_utils.R
}
\usage{
\method{pfa}{ets}(object, name = NULL, version = NULL, doc = NULL,
  metadata = NULL, randseed = NULL, options = NULL, cycle_reset = TRUE,
  ...)
}
\arguments{
\item{object}{an object of class "ets"}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for 
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random 
numbers. Multiple scoring engines derived from the same PFA file have 
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name 
Initialization or runtime options to customize implementation 
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{cycle_reset}{a logical indicating whether to reset the state back to the 
last point of the trained model before forecasting or to continue cycling forward 
through trend and seasonality with every new call to the engine. The default is 
TRUE so that repeated calls yield the same forecast as repeated calls to 
\code{\link[forecast]{forecast}}.}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose valid PFA document
}
\description{
This function takes an Exponential smoothing state space model created 
using the ets() function from the forecast package and returns a 
list-of-lists representing in valid PFA document that could be used for scoring.
}
\examples{
model <- forecast::ets(USAccDeaths, model="ZZZ")
model_as_pfa <- pfa(model)
}
\seealso{
\code{\link[forecast]{ets}} \code{\link{extract_params.ets}}
}
