% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet.R
\name{extract_params.glmnet}
\alias{extract_params.glmnet}
\title{extract_params.glmnet}
\usage{
\method{extract_params}{glmnet}(object, lambda = NULL, ...)
}
\arguments{
\item{object}{an object of class "glmnet"}

\item{lambda}{a numeric value of the penalty parameter lambda at which 
coefficients are required}

\item{...}{further arguments passed to or from other methods}
}
\value{
a \code{list} of lists that can be modified to insert into a cell or pool
}
\description{
Extract generalized linear model net parameters from the glmnet library
}
\examples{
X <- matrix(c(rnorm(100), runif(100)), nrow=100, ncol=2)
Y <- factor(3 - 5 * X[,1] + 3 * X[,2] + rnorm(100, 0, 3) > 0)

model <- glmnet::glmnet(X, Y, family = 'binomial')
my_model_params <- extract_params(model)
}
