% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naiveBayes.R
\name{build_model.naiveBayes}
\alias{build_model.naiveBayes}
\title{build_model.naiveBayes}
\usage{
\method{build_model}{naiveBayes}(object, threshold = 0.001, eps = 0, ...)
}
\arguments{
\item{object}{a object of class naiveBayes}

\item{threshold}{a value replacing cells with probabilities within eps range.}

\item{eps}{a numeric for specifying an epsilon-range to apply laplace 
smoothing (to replace zero or close-zero probabilities by theshold.)}

\item{...}{further arguments passed to or from other methods}
}
\value{
a \code{list} of lists representation of the naiveBayes model that can be 
inserted into a cell or pool
}
\description{
Builds an entire PFA list of lists based on a naiveBayes
}
\examples{
model <- e1071::naiveBayes(Species ~ ., data=iris) 
model_built <- build_model(model)
}
