% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-select.r
\name{auk_select}
\alias{auk_select}
\title{Select a subset of columns}
\usage{
auk_select(x, select, file, sep = "\\t", overwrite = FALSE)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{select}{character; a character vector specifying the names of the
columns to select. Columns should be as they appear in the header of the
EBD; however, names are not case sensitive and spaces may be replaced by
underscores, e.g. \code{"COMMON NAME"}, \code{"common name"}, and \code{"common_NAME"} are
all valid.}

\item{file}{character; output file.}

\item{sep}{character; the input field separator, the eBird file is tab
separated by default. Must only be a single character and space delimited
is not allowed since spaces appear in many of the fields.}

\item{overwrite}{logical; overwrite output file if it already exists}
}
\value{
Invisibly returns the filename of the output file.
}
\description{
Select a subset of columns from the eBird Basic Dataset (EBD) or the sampling
events file. Subsetting the columns can significantly decrease file size.
}
\examples{
\dontrun{
# select a minimal set of columns
out_file <- tempfile()
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
cols <- c("latitude", "longitude",
          "group identifier", "sampling event identifier", 
          "scientific name", "observation count",
          "observer_id")
selected <- auk_select(ebd, select = cols, file = out_file)
str(read_ebd(selected))
}
}
\seealso{
Other text: 
\code{\link{auk_clean}()},
\code{\link{auk_split}()}
}
\concept{text}
