% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-duration.r
\name{auk_duration}
\alias{auk_duration}
\title{Filter the EBD by duration}
\usage{
auk_duration(x, duration)
}
\arguments{
\item{x}{\code{auk_ebd} object; reference to EBD file created by \code{\link[=auk_ebd]{auk_ebd()}}.}

\item{duration}{integer; 2 element vector specifying the range of durations
in minutes to filter by.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on the duration of
the checklist. This function only defines the filter and, once all filters
have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\examples{
# only keep checklists that are less than an hour long
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_duration(duration = c(0, 60))
}
