% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc.R
\name{plot_roc}
\alias{plot_roc}
\alias{plotROC}
\title{Receiver Operating Characteristic (ROC)}
\usage{
plot_roc(object, ..., nlabel = NULL)

plotROC(object, ..., nlabel = NULL)
}
\arguments{
\item{object}{An object of class 'auditor_model_evaluation' created with \code{\link{model_evaluation}} function.}

\item{...}{Other 'auditor_model_evaluation' objects to be plotted together.}

\item{nlabel}{Number of cutoff points to show on the plot. Default is `NULL`.}
}
\value{
A ggplot object.
}
\description{
Receiver Operating Characterstic Curve is a plot of the true positive rate (TPR) against the false positive rate (FPR) for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- as.numeric(titanic$survived == "yes")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, y = titanic$survived)

# validate a model with auditor
library(auditor)
eva_glm <- model_evaluation(exp_glm)

# plot results
plot_roc(eva_glm)
plot(eva_glm)

#add second model
model_glm_2 <- glm(survived ~ .-age, family = binomial, data = titanic)
exp_glm_2 <- DALEX::explain(model_glm_2, data = titanic, y = titanic$survived, label = "glm2")
eva_glm_2 <- model_evaluation(exp_glm_2)

plot_roc(eva_glm, eva_glm_2)
plot(eva_glm, eva_glm_2)

}
\seealso{
\code{\link{plot_rroc}, \link{plot_rec}}
}
