% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.r
\name{search_post}
\alias{search_post}
\title{Search Posts}
\usage{
search_post(q, limit = 100L, parse = TRUE, verbose = NULL, .token = NULL)
}
\arguments{
\item{q}{Find posts matching search criteria. API docs claim that Lucene
query syntax is supported (boolean operators and brackets for complex
queries). But only whitespace as implicit AN seems to work.}

\item{limit}{Maximum number of records to return. For queries with more than
100 results, pagination is used automatically (one request per 100
results). The function stops when the limit is reached, but you will
usually get a few items more than requested.}

\item{parse}{Parse the results or return the original nested object sent by
the server.}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}
}
\value{
a data frame (or nested list) of posts
}
\description{
Search Posts
}
\examples{
\dontrun{
search_post("rstats")
# finds post with rstats and Bluesky in text
search_post("rstats Bluesky")
# does not find anything, since hashtags seem to be treated differently
search_post("#rstats")
}
}
