% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotmcmc}
\alias{plotmcmc}
\title{plots output from `atmcmc'}
\usage{
plotmcmc(output, name = "MCMC", multimodal = F, plottype = "trace",
  format = "default", m = 10, phase.start = 1, phase.end = 5,
  nrow.trace = 3, ncol.trace = 1, nrow.hist = 3, ncol.hist = 3)
}
\arguments{
\item{output}{output from an `atmcmc' run}

\item{name}{name of the project}

\item{multimodal}{whether to assume target density function is strongly multimodal. Argument takes T or F}

\item{plottype}{whether to produce traceplots or histograms, or both. Takes argument `trace', `hist', or `all'}

\item{format}{file format. R graphics, pdf, or png. Takes argument `default', `pdf', or `png'}

\item{m}{every `m'th iteration is plotted. Has to be a factor of `batchwidth'/2 from the `atmcmc' run}

\item{phase.start}{first phase to be plotted in traceplots. Takes argument 1, 2, 3, 4, or 5. 1 = 1st adaption phase, 2 = transient phase, 3 = 2nd adaption phase, 4 = 1st half of sampling phase, and 5 = 2nd half of sampling phase}

\item{phase.end}{last phase to be plotted in traceplots. Takes argument 1, 2, 3, 4, or 5. 1 = 1st adaption phase, 2 = transient phase, 3 = 2nd adaption phase, 4 = 1st half of sampling phase, and 5 = 2nd half of sampling phase}

\item{nrow.trace}{number of rows for traceplots per page}

\item{ncol.trace}{number of columns for traceplots per page}

\item{nrow.hist}{number of rows for histograms per page}

\item{ncol.hist}{number of columns for histograms per page}
}
\value{
Plots including
 \item{`name'_histogram}{histograms of the sample obtained from the `atmcmc' run}
 \item{`name'_traceplot}{traceplots from the `atmcmc' run. Every `m'th iteration is plotted}
}
\description{
Produces traceplots and histograms of output from an `atmcmc' run
}
\details{
Histograms and traceplots are drawn for each coordinate separately. For the sampling phase, traceplots show only one replicative chain (chain that takes the last value of the 2nd adaption phase as the starting value of the sampling phase).
}
\examples{
## see examples in `atmcmc'
}

