% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_param_histo.R
\name{f_param_histo}
\alias{f_param_histo}
\title{Historical parameters}
\usage{
f_param_histo(qt_trgt, v_dep, v_expl, type_function, starting_values)
}
\arguments{
\item{qt_trgt}{Numeric vector, dim k, of k quantiles for different qt-estimations (k>=4)}

\item{v_dep}{Numeric vector of the dependent variable}

\item{v_expl}{Numeric vector of the (k) explanatory variable(s)}

\item{type_function}{String argument : "gaussian" for normal distribution or "skew-t" for t-student distribution}

\item{starting_values}{Numeric vector with initial values for optimization}
}
\value{
A matrix with the historical parameters of the distribution
}
\description{
This function allows to calculate historical parameters of distributions.
}
\examples{
\donttest{
# Import data
data("data_US")

# Data process data_US
PIB_us_forward_1 = data_US["GDP"][c(2:length(data_US["GDP"][,1])),]
NFCI_us_lag_1 = data_US["NFCI"][c(1:(length(data_US["GDP"][,1]) - 1)),]

# Historical parameters for a skew-t distribution
results_s <- f_param_histo(qt_trgt= as.vector(c(0.10,0.25,0.75,0.90)),
v_dep=PIB_us_forward_1,
v_expl=NFCI_us_lag_1,
type_function="skew-t",
starting_values=c(0, 1, -0.5, 1.3))
}

}
