\name{assert_all_are_cas_numbers}
\alias{assert_all_are_cas_numbers}
\alias{assert_any_are_cas_numbers}
\alias{is_cas_number}
\title{Does the character vector contain CAS registry numbers?}
\usage{
  assert_all_are_cas_numbers(x)

  assert_any_are_cas_numbers(x)

  is_cas_number(x, .xname = get_name_in_parent(x))
}
\arguments{
  \item{x}{Input to check.}

  \item{.xname}{Not intended to be called directly.}
}
\value{
  A logical vector that is \code{TRUE} when the input
  contains valid CAS registry numbers.
}
\description{
  Checks that the input contains Chemical Abstract Service
  registry numbers.
}
\note{
  CAS numbers take the form of 1 to 7 digits followed by a
  hyphen, followed by 2 digits, another hyphen and a final
  check digit.
}
\examples{
x <- c(
  water = "7732-18-5",
  d_glucose = "50-99-7",
  l_glucose = "921-60-8",
  no_hyphens = "7732185",
  two_check_digits = "7732-18-55",
  bad_check_digit = "7732-18-4"
)
is_cas_number(x)
assert_any_are_cas_numbers(x)
\dontrun{
#These examples should fail.
assert_all_are_cas_numbers(x)
}
}
\references{
  Chemspider is a good service for looking up CAS numbers.
}

