% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-type-base.R, R/is-type-base.R
\name{assert_is_qr}
\alias{assert_is_qr}
\alias{is_qr}
\title{Is the input a QR decomposition of a matrix?}
\usage{
assert_is_qr(x, severity = getOption("assertive.severity", "stop"))

is_qr(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_qr} wraps \code{is.qr}, providing more 
information on failure.  \code{assert_is_qr} returns nothing but
throws an error if \code{is_qr} returns \code{FALSE}.
}
\description{
Checks to see if the input is a QR decomposition of a matrix.
}
\examples{
assert_is_qr(qr(matrix(rnorm(25), nrow = 5)))
}
\seealso{
\code{\link[base]{is.qr}}.
}

