% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-32-64-bit.R, R/assert-is-os.R, R/is-32-64-bit.R, R/is-os.R
\name{assert_is_64_bit_os}
\alias{assert_is_32_bit}
\alias{assert_is_64_bit}
\alias{assert_is_64_bit_os}
\alias{assert_is_bsd}
\alias{assert_is_linux}
\alias{assert_is_mac}
\alias{assert_is_macos_sierra}
\alias{assert_is_osx}
\alias{assert_is_osx_cheetah}
\alias{assert_is_osx_el_capitan}
\alias{assert_is_osx_jaguar}
\alias{assert_is_osx_leopard}
\alias{assert_is_osx_lion}
\alias{assert_is_osx_mavericks}
\alias{assert_is_osx_mountain_lion}
\alias{assert_is_osx_panther}
\alias{assert_is_osx_puma}
\alias{assert_is_osx_snow_leopard}
\alias{assert_is_osx_tiger}
\alias{assert_is_osx_yosemite}
\alias{assert_is_solaris}
\alias{assert_is_unix}
\alias{assert_is_windows}
\alias{assert_is_windows_10}
\alias{assert_is_windows_7}
\alias{assert_is_windows_8}
\alias{assert_is_windows_8.1}
\alias{assert_is_windows_server_2008}
\alias{assert_is_windows_server_2008_r2}
\alias{assert_is_windows_server_2012}
\alias{assert_is_windows_server_2012_r2}
\alias{assert_is_windows_vista}
\alias{is_32_bit}
\alias{is_64_bit}
\alias{is_64_bit_os}
\alias{is_bsd}
\alias{is_linux}
\alias{is_mac}
\alias{is_macos_sierra}
\alias{is_osx}
\alias{is_osx_cheetah}
\alias{is_osx_el_capitan}
\alias{is_osx_jaguar}
\alias{is_osx_leopard}
\alias{is_osx_lion}
\alias{is_osx_mavericks}
\alias{is_osx_mountain_lion}
\alias{is_osx_panther}
\alias{is_osx_puma}
\alias{is_osx_snow_leopard}
\alias{is_osx_tiger}
\alias{is_osx_yosemite}
\alias{is_solaris}
\alias{is_unix}
\alias{is_windows}
\alias{is_windows_10}
\alias{is_windows_7}
\alias{is_windows_8}
\alias{is_windows_8.1}
\alias{is_windows_server_2008}
\alias{is_windows_server_2008_r2}
\alias{is_windows_server_2012}
\alias{is_windows_server_2012_r2}
\alias{is_windows_vista}
\title{What OS is running?}
\usage{
assert_is_64_bit_os(severity = getOption("assertive.severity", "stop"))

assert_is_32_bit(severity = getOption("assertive.severity", "stop"))

assert_is_64_bit(severity = getOption("assertive.severity", "stop"))

assert_is_bsd(severity = getOption("assertive.severity", "stop"))

assert_is_linux(severity = getOption("assertive.severity", "stop"))

assert_is_mac(severity = getOption("assertive.severity", "stop"))

assert_is_osx(severity = getOption("assertive.severity", "stop"))

assert_is_osx_cheetah(severity = getOption("assertive.severity", "stop"))

assert_is_osx_puma(severity = getOption("assertive.severity", "stop"))

assert_is_osx_jaguar(severity = getOption("assertive.severity", "stop"))

assert_is_osx_panther(severity = getOption("assertive.severity", "stop"))

assert_is_osx_tiger(severity = getOption("assertive.severity", "stop"))

assert_is_osx_leopard(severity = getOption("assertive.severity", "stop"))

assert_is_osx_snow_leopard(severity = getOption("assertive.severity", "stop"))

assert_is_osx_lion(severity = getOption("assertive.severity", "stop"))

assert_is_osx_mountain_lion(severity = getOption("assertive.severity",
  "stop"))

assert_is_osx_mavericks(severity = getOption("assertive.severity", "stop"))

assert_is_osx_yosemite(severity = getOption("assertive.severity", "stop"))

assert_is_osx_el_capitan(severity = getOption("assertive.severity", "stop"))

assert_is_macos_sierra(severity = getOption("assertive.severity", "stop"))

assert_is_solaris(severity = getOption("assertive.severity", "stop"))

assert_is_unix(severity = getOption("assertive.severity", "stop"))

assert_is_windows(severity = getOption("assertive.severity", "stop"))

assert_is_windows_vista(severity = getOption("assertive.severity", "stop"))

assert_is_windows_7(severity = getOption("assertive.severity", "stop"))

assert_is_windows_8(severity = getOption("assertive.severity", "stop"))

assert_is_windows_8.1(severity = getOption("assertive.severity", "stop"))

assert_is_windows_10(severity = getOption("assertive.severity", "stop"))

assert_is_windows_server_2008(severity = getOption("assertive.severity",
  "stop"))

assert_is_windows_server_2008_r2(severity = getOption("assertive.severity",
  "stop"))

assert_is_windows_server_2012(severity = getOption("assertive.severity",
  "stop"))

assert_is_windows_server_2012_r2(severity = getOption("assertive.severity",
  "stop"))

is_64_bit_os()

is_32_bit()

is_64_bit()

is_bsd()

is_linux()

is_mac()

is_osx()

is_osx_cheetah()

is_osx_puma()

is_osx_jaguar()

is_osx_panther()

is_osx_tiger()

is_osx_leopard()

is_osx_snow_leopard()

is_osx_lion()

is_osx_mountain_lion()

is_osx_mavericks()

is_osx_yosemite()

is_osx_el_capitan()

is_macos_sierra()

is_solaris()

is_unix()

is_windows()

is_windows_vista()

is_windows_7()

is_windows_8()

is_windows_8.1()

is_windows_10()

is_windows_server_2008()

is_windows_server_2008_r2()

is_windows_server_2012()

is_windows_server_2012_r2()
}
\arguments{
\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{is_windows} returns \code{TRUE} if the OS on the current 
platform is Microsoft windows-based.  \code{is_unix} returns \code{TRUE} if 
the OS is Unix based (pretty much anything that isn't Windows, including OS 
X). 
\code{is_mac}, \code{is_linux}, \code{is_bsd}, \code{is_solaris} return 
\code{TRUE} if the OS is Apple OS X, Linux, FreeBSD/NetBSD, or Solaris 
respectively.
\code{is_64_bit_os} returns \code{TRUE} when the operating system is 64-bit.
The \code{assert_*} functions return nothing but throw an error if the 
corresponding \code{is_*} functions return \code{FALSE}.
}
\description{
Is the operating system in this machine Windows/Unix/Mac based.
}
\examples{
is_unix()
is_linux()
is_bsd()
is_solaris()
if(is_windows())
{
  assertive.base::dont_stop({
    assert_is_windows_vista()
    assert_is_windows_7()
    assert_is_windows_8()
    assert_is_windows_8.1()
    assert_is_windows_10()
    assert_is_windows_server_2008()
    assert_is_windows_server_2008_r2()
    assert_is_windows_server_2012()
    assert_is_windows_server_2012_r2()
  })
}
if(is_osx()) # is_mac is a synonym
{
  assertive.base::dont_stop({
    assert_is_osx_cheetah()
    assert_is_osx_puma()
    assert_is_osx_jaguar()
    assert_is_osx_panther()
    assert_is_osx_tiger()
    assert_is_osx_leopard()
    assert_is_osx_snow_leopard()
    assert_is_osx_lion()
    assert_is_osx_mountain_lion()
    assert_is_osx_mavericks()
    assert_is_osx_yosemite()
    assert_is_osx_el_capitan()
    assert_is_macos_sierra() # note the change from OSX to macOS
  })
}
is_32_bit()
is_64_bit()
assertive.base::dont_stop(assert_is_windows())
assertive.base::dont_stop(assert_is_unix())
}
\references{
With the exception of \code{is_windows} and \code{is_unix} that 
use \code{.Platform$OS.type}, the OS is determined from 
\code{Sys.info()[["sysname"]]}, which (not on Windows) is calculated via the 
OS \code{uname} program.  GNU has more information on the return value: 
\url{https://www.gnu.org/software/libc/manual/html_node/Platform-Type.html}
and Wikipedia has a nice list of possible values: 
\url{https://en.wikipedia.org/wiki/Uname#Examples}
The names for different versions of Windows are decribed in:
\url{http://svn.r-project.org/R/trunk/src/library/utils/src/windows/util.c}
}
\seealso{
\code{\link[base]{.Platform}}, \code{\link[base]{Sys.info}}, 
\code{\link[base]{version}}, and \code{win.version}.
}

