% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_set.R
\name{assert_subset}
\alias{assert_subset}
\title{Check if a vector is a subset of another}
\usage{
assert_subset(x, y, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{A vector to check}

\item{y}{the acceptible values that x can take}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
Returns invisible(TRUE) if \code{x} is a subset of \code{y}, otherwise throws an error
}
\description{
This function checks that \code{x} is a subset of \code{y}
}
\examples{
try({
assert_subset(1:3, 1:5) # Passes
assert_subset(c("A", "B", "C"), c("A", "B")) # Throws error since "C" is not present in first vector
})
}
