% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issues.R
\name{check}
\alias{check}
\title{Checking for issues}
\usage{
check(model)
}
\arguments{
\item{model}{Model to check}
}
\value{
An issue list (printed to the console by default)
}
\description{
This function checks a model for existing issues.
}
\details{
The function accepts a model object and returns a list of issues that can help to identify problems in a model.
If no issues are found, a message and an empty list are produced. Issues can either be critical or non-critical,
depending on whether a valid model could still be rendered.

The function currently detects the following issues:
\itemize{
\item Undefined variables
\item Lack of parameters
\item Lack of observations
\item Lack of distribution/elimination components (pk_model)
\item Inconsistent capitalization of variable names
}
}
\examples{
m <- model() +
    prm_log_normal("emax") +
    prm_log_normal("ed50") +
    obs_additive(eff~emax*dose/(ed50+dose))
check(m)

# fix issue
m <- m + input_variable("dose")
check(m)
}
