% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{get_lfsr}
\alias{get_lfsr}
\alias{get_lfdr}
\alias{get_svalue}
\alias{get_qvalue}
\alias{get_pm}
\alias{get_psd}
\alias{get_pp}
\alias{get_np}
\alias{get_loglik}
\alias{get_logLR}
\alias{get_fitted_g}
\alias{get_pi0}
\title{Return lfsr from an ash object}
\usage{
get_lfsr(x)

get_lfdr(a)

get_svalue(a)

get_qvalue(a)

get_pm(a)

get_psd(a)

get_pp(a)

get_np(a)

get_loglik(a)

get_logLR(a)

get_fitted_g(a)

get_pi0(a)
}
\arguments{
\item{x}{an ash fit (e.g. from running ash)}

\item{a}{an ash fit (e.g. from running ash)}
}
\value{
a vector (ash) of local false sign rates
}
\description{
These functions simply return elements of an ash object, generally without doing any calculations.
(So if the value was not computed during the original call to ash, eg because of how outputlevel was set in the call,
then NULL will be returned.)
Accessing elements in this way
rather than directly from the ash object will help ensure compatability moving forward
(e.g. if the internal structure of the ash object changes during software development.)
}
\section{Functions}{
\itemize{
\item \code{get_lfsr}: local false sign rate

\item \code{get_lfdr}: local false discovery rate

\item \code{get_svalue}: svalue

\item \code{get_qvalue}: qvalue

\item \code{get_pm}: posterior mean

\item \code{get_psd}: posterior standard deviation

\item \code{get_pp}: positive probability

\item \code{get_np}: negative probability

\item \code{get_loglik}: log-likelihood

\item \code{get_logLR}: log-likelihood ratio

\item \code{get_fitted_g}: fitted g mixture

\item \code{get_pi0}: pi0, the proportion of nulls
}}

