% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicate-data}
\alias{predicate-data}
\alias{has_missing}
\alias{has_infinite}
\alias{has_duplicates}
\alias{is_unique}
\title{Utility Predicates}
\usage{
has_missing(x)

has_infinite(x)

has_duplicates(x)

is_unique(x, tolerance = sqrt(.Machine$double.eps), na.rm = FALSE)
}
\arguments{
\item{x}{A \code{\link{vector}} to be tested.}

\item{tolerance}{A \code{\link{numeric}} scalar giving the tolerance to check within
(for \code{numeric} vector).}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values (including \code{NaN})
be omitted?}
}
\value{
A \code{\link{logical}} scalar.
}
\description{
\itemize{
\item \code{has_missing()} and \code{has_infinite()} check if an object contains missing
or infinite values.
\item \code{has_duplicates()} checks if an object has duplicated elements.
}
}
\seealso{
Other predicates: 
\code{\link{is_scalar}},
\code{\link{predicate-attributes}},
\code{\link{predicate-matrix}},
\code{\link{predicate-names}},
\code{\link{predicate-numeric}},
\code{\link{predicate-trend}},
\code{\link{predicate-type}}
}
\concept{predicates}
