% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/compact.R
\docType{methods}
\name{compact}
\alias{compact}
\alias{compact-method}
\alias{compact_cols}
\alias{compact_cols-method}
\alias{compact_rows}
\alias{compact_rows-method}
\alias{compact,ANY-method}
\alias{compact_cols,ANY-method}
\alias{compact_rows,ANY-method}
\title{Remove Empty Rows/Columns}
\usage{
compact(x, ...)

compact_cols(x, ...)

compact_rows(x, ...)

\S4method{compact}{ANY}(x, margin = 1)

\S4method{compact_cols}{ANY}(x)

\S4method{compact_rows}{ANY}(x)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscripts which the
function will be applied over (\code{1} indicates rows, \code{2} indicates columns).}
}
\description{
Removes empty rows/columns in an array-like object using a predicate
function.
}
\details{
A row/column is empty if it contains only \code{NA}, zeros (if of type \code{numeric})
or zero length character strings (if of type \code{character}).
}
\examples{
## Create a data.frame
X <- data.frame(A = 0, B = 1:5, C = 6, D = "", F = letters[1:5])
X

## Remove empty columns
compact(X, margin = 2)
}
\seealso{
\code{\link[=remove_NA]{remove_NA()}}, \code{\link[=remove_zero]{remove_zero()}}, \code{\link[=remove_empty]{remove_empty()}}

Other data cleaning tools: 
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{empty}},
\code{\link{infinite}},
\code{\link{keep}()},
\code{\link{missing}},
\code{\link{remove_constant}()},
\code{\link{zero}}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
