% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/discard.R
\docType{methods}
\name{discard}
\alias{discard}
\alias{discard-method}
\alias{discard_cols}
\alias{discard_cols-method}
\alias{discard_rows}
\alias{discard_rows-method}
\alias{discard,ANY,function-method}
\alias{discard_rows,ANY,function-method}
\alias{discard_cols,ANY,function-method}
\title{Remove rows/columns using a predicate}
\usage{
discard(x, f, ...)

discard_cols(x, f, ...)

discard_rows(x, f, ...)

\S4method{discard}{ANY,`function`}(x, f, margin = 1, negate = FALSE, all = FALSE)

\S4method{discard_rows}{ANY,`function`}(x, f, negate = FALSE, all = FALSE)

\S4method{discard_cols}{ANY,`function`}(x, f, negate = FALSE, all = FALSE)
}
\arguments{
\item{x}{An object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{f}{A predicate \code{\link{function}}.}

\item{...}{Currently not used.}

\item{margin}{A vector giving the subscripts which the function will be
applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{negate}{A \code{\link{logical}} scalar: should the negation of \code{f} be used
instead of \code{f}?}

\item{all}{A \code{\link{logical}} scalar. If \code{TRUE}, only the rows/columns whose
values all meet the condition defined by \code{f} are considered. If \code{FALSE}
(the default), only rows/columns where at least one value validates the
condition defined by \code{f} are considered.}
}
\description{
Removes rows/columns in an array-like object using a predicate function.
}
\examples{
## Create a count data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Count missing values in rows
count(X, f = is.na, margin = 1)
## Count non-missing values in columns
count(X, f = is.na, margin = 2, negate = TRUE)

## Find row with NA
detect(X, f = is.na, margin = 1)
## Find column without any NA
detect(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Keep row without any NA
keep(X, f = is.na, margin = 1, negate = TRUE, all = TRUE)
## Keep row without any NA
keep(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Remove row with any NA
discard(X, f = is.na, margin = 1, all = FALSE)
## Remove column with any NA
discard(X, f = is.na, margin = 2, all = FALSE)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{compact}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{infinite}},
\code{\link{keep}()},
\code{\link{missing}},
\code{\link{zero}}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
