% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_chunks.R
\name{process_chunks}
\alias{process_chunks}
\title{process a table in chunks}
\usage{
process_chunks(
  file,
  process_fn,
  streamable_table = NULL,
  lines = 50000L,
  encoding = Sys.getenv("encoding", "UTF-8"),
  ...
)
}
\arguments{
\item{file}{path to a file}

\item{process_fn}{a function of a \code{chunk}}

\item{streamable_table}{interface for serializing/deserializing in chunks}

\item{lines}{number of lines to read in a chunk.}

\item{encoding}{encoding to be assumed for input files.}

\item{...}{additional arguments to \code{streamable_table$read} method.}
}
\description{
process a table in chunks
}
\examples{
con <- system.file("extdata/mtcars.tsv.gz", package="arkdb")
dummy <- function(x) message(paste(dim(x), collapse = " x "))
process_chunks(con, dummy, lines = 8)

}
