% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{profile.Arima2}
\alias{profile.Arima2}
\title{Profile for \code{Arima2} object}
\usage{
\method{profile}{Arima2}(
  fitted,
  d = 0,
  npts = 100L,
  lower = -1,
  upper = 1,
  which = 1L,
  max_iters = 1,
  ...
)
}
\arguments{
\item{fitted}{An \code{Arima2} object that has been fit to data.}

\item{d}{Integer number of differences. Should match the differences used to
obtain the \code{fitted} object.}

\item{npts}{Integer number of points to evaluate the profile.}

\item{lower}{Numeric lower bound for the profile search.}

\item{upper}{Numeric upper bound for the profile search.}

\item{which}{Integer indicating which parameter to perform the profile over.
See Details section for more information.}

\item{max_iters}{Maximum number of random restarts. See \link{arima} for more
details.}

\item{...}{additional arguments needed for the profile function}
}
\value{
data.frame object containing the results of the profile likelihood.
}
\description{
This function performs profile log-likelihood of an \code{Arima2} function.
}
\details{
The parameter \code{which} specifies parameter in the following vector will be
profiled over:
\deqn{\phi_1, \ldots, \phi_p, \theta_1, \ldots, \theta_q, \Phi_1, \ldots, \Phi_P, \Theta_1, \ldots, \Theta_Q, \mu}
where \eqn{p, q} are non-negative integers representing the number of AR and
MA coefficients of \code{fitted}, respectively, and \eqn{\phi_i} are the AR
coefficients, \eqn{\theta_i} are the MA coefficients, \eqn{\Phi_i} are the
seasonal AR coefficients, \eqn{\Theta_i} are the seasonal MA coefficients and
\eqn{\mu} is the model intercept.
}
\examples{
# example code
set.seed(123)
mod <- arima(miHuron_level$Average, order = c(1, 0, 1), max_iters = 100)
prof <- profile(mod, which = 2L, lower = -0.5, upper = 0.5)
plot(prof$ma1, prof$loglik)

}
