% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityfcns.R
\name{removeMode}
\alias{removeMode}
\title{Removes a mode from an \code{arfima} fit.}
\usage{
removeMode(object, num)
}
\arguments{
\item{object}{An object of class "arfima".}

\item{num}{The number of the mode as in the printed value of the object.}
}
\value{
The original object with the mode removed.
}
\description{
This function is useful if one suspects a mode is spurious and does not want
to call the weed function.
}
\examples{

\donttest{
set.seed(8765)
sim <- arfima.sim(1000, model = list(phi = 0.4, theta = 0.9, dfrac = 0.4))
fit <- arfima(sim, order = c(1, 0, 1), back=T)
fit
fit <- removeMode(fit, 3)
fit
}

}
\seealso{
\code{\link{arfima}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{ts}
