% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityfcns.R
\name{fitted.arfima}
\alias{fitted.arfima}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{arfima}(object, ...)
}
\arguments{
\item{object}{A \code{arfima} object.}

\item{\dots}{Optional parameters.  Currently not used.}
}
\value{
A list of vectors of fitted values, one for each mode.
}
\description{
Extract fitted values from an \code{arfima} object.
}
\examples{

\dontrun{
set.seed(8564)
sim <- arfima.sim(1000, model = list(phi = c(0.2, 0.1), dfrac = 0.4, theta = 0.9))
fit <- arfima(sim, order = c(2, 0, 1))

fit

resid <- resid(fit)
par(mfrow = c(1, 3))
fitted <- fitted(fit)
plot(fitted[[1]], resid[[1]])
plot(fitted[[2]], resid[[2]])
plot(fitted[[3]], resid[[3]])
par(mfrow = c(1, 1))
}

}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\seealso{
\code{\link{arfima}}, \code{\link{resid.arfima}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{ts}
