% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aread.R
\name{aread}
\alias{aread}
\title{Read Artifacts Given as md5hashes from the Repository}
\usage{
aread(md5hash)
}
\arguments{
\item{md5hash}{One of the following:

A character vector which elements  are consisting of at least three components separated with '/': GitHub user name, GitHub repository and name of the artifact (MD5 hash) or it's abbreviation.

MD5 hashes of artifacts in current local default directory or its abbreviations.}
}
\description{
\code{aread} reads the artifact from the \link{Repository}. It's a wrapper around
\link{loadFromLocalRepo} and \link{loadFromGithubRepo}.
}
\details{
Function \code{aread} reads artifacts (by \code{md5hashes}) from GitHub Repository.
It uses \link{loadFromLocalRepo} and \link{loadFromGithubRepo} functions
with different parameter's specification.
}
\note{
Before you start using this function, remember to set local or github repository
to default by using \code{setLocalRepo()} or \code{setGithubRepo} functions.
}
\examples{
\dontrun{
# read the object from local directory
setLocalRepo(system.file("graphGallery", package = "archivist"))
pl <- aread("2166dfbd3a7a68a91a2f8e6df1a44111")
# plot it
pl
# read the object from GitHub
pl <- aread("pbiecek/graphGallery/2166dfbd3a7a68a91a2f8e6df1a44111")
# plot it
pl
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{agithub}},
  \code{\link{archivist-github-integration}};
  \code{\link{ahistory}}; \code{\link{aoptions}};
  \code{\link{archive}}; \code{\link{archivist-package}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{cloneGithubRepo}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyGithubRepo}},
  \code{\link{createEmptyLocalRepo}},
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{splitTagsGithub}},
  \code{\link{splitTagsLocal}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

