% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/asearch.R
\name{asearch}
\alias{asearch}
\title{Read Artifacts Given as a List of Tags}
\usage{
asearch(patterns, repo = NULL)
}
\arguments{
\item{patterns}{A character vector of tags. Only artifacts that
contain all tags are returned.}

\item{repo}{One of following:

A character with GitHub user name and GitHub repository name separated by `/`.

NULL in this case search will be performed in the default repo.}
}
\value{
This function returns list of artifacts (by value).
}
\description{
\code{asearch} searches for artifacts that contain all specified Tags
and reads all of them from a Github \link{Repository}. It's a wrapper around
\link{multiSearchInGithubRepo} and \link{loadFromGithubRepo}.
}
\details{
Function \code{asearch} reads all artifacts that contain given list of tags
from GitHub Repository.
It uses the function \link{loadFromGithubRepo} and
\link{multiSearchInGithubRepo} but has shorter name and
different paramter's specification.
}
\examples{
\dontrun{
# read the object
asearch("pbiecek/graphGallery",
           patterns = list("class:lm",
                "varname:Species")))
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{cache}}; \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

