% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Repository.R
\docType{class}
\name{Repository}
\alias{Repository}
\title{Repository}
\description{
\code{Repository} stores specific values of an artifact,
different for various artifact's classes, and artifacts
themselves. To learn more about artifacts visit
\link[archivist]{archivist-package}.
}
\details{
\code{Repository} is folder with an SQLite database stored
in a file named \code{backpack} and a subdirectory named
\code{gallery} with collection of artifact saved as
\code{.rda} files.
}
\seealso{
Functions using \code{Repository} are: \itemize{ \item
\link{saveToRepo}, \item \link{rmFromRepo}, \item
\link{loadFromLocalRepo}, \item \link{loadFromGithubRepo},
\item \link{searchInLocalRepo}, \item
\link{searchInGithubRepo}, \item \link{summaryLocalRepo},
\item \link{summaryGithubRepo}.  }

Function creating \code{Repository} is: \itemize{ \item
\link{createEmptyRepo}. } Functions coping
\code{Repository} are: \itemize{ \item
\link{copyLocalRepo}, \item \link{copyGithubRepo}. }

Function deleting \code{Repository} is: \itemize{ \item
\link{deleteRepo}. }

Learn more about \code{Repository} at \pkg{archivist}
\code{wiki} webpage on
\href{https://github.com/pbiecek/archivist/wiki/archivist-package-Repository}{Github}.

Other archivist: \code{\link{Tags}};
\code{\link{addTagsRepo}}; \code{\link{archivist-package}};
\code{\link{cache}}; \code{\link{copyGithubRepo}},
\code{\link{copyLocalRepo}}; \code{\link{createEmptyRepo}};
\code{\link{deleteRepo}}; \code{\link{getTagsGithub}},
\code{\link{getTagsLocal}};
\code{\link{loadFromGithubRepo}},
\code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
\code{\link{multiSearchInGithubRepo}},
\code{\link{multiSearchInLocalRepo}},
\code{\link{searchInGithubRepo}},
\code{\link{searchInLocalRepo}}; \code{\link{rmFromRepo}};
\code{\link{saveToRepo}}; \code{\link{setGithubRepo}},
\code{\link{setLocalRepo}};
\code{\link{shinySearchInLocalRepo}};
\code{\link{showGithubRepo}}, \code{\link{showLocalRepo}};
\code{\link{summaryGithubRepo}},
\code{\link{summaryLocalRepo}};
\code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

