% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arabic2kansuji.R
\name{arabic2kansuji}
\alias{arabic2kansuji}
\alias{arabic2kansuji_num}
\alias{arabic2kansuji_all}
\title{Convert Arabic numerals to Kansuji}
\usage{
arabic2kansuji(str, zero = c("rei", "zero"), width = c("half", "full", "all"))

arabic2kansuji_num(num, ...)

arabic2kansuji_all(str, widths = c("half", "all"), ...)
}
\arguments{
\item{str}{Input vector.}

\item{zero}{Selects whether 0 should be zero like o ("rei") or zero like have
rain crown ("zero") when Arabic numerals are converted to kansuji.}

\item{width}{Selects whether you want to convert Arabic numbers, only
half-width numbers ("half") or only full-width
numbers ("full") or both half-width and full-width
numbers ("all") when converting Arabic numbers to kansuji.}

\item{num}{Input only number. Accept more than one number.}

\item{...}{Other arguments to carry over to `arabic2kansuji()`.}

\item{widths}{Selects whether you want to convert Arabic numbers, only
half-width numbers ("half") or both half-width and
full-width numbers ("all") when converting Arabic numbers to
kansuji.}
}
\value{
a character.
}
\description{
Converts a given Arabic numerals to Kansuji numerical figures that written
in Chinese characters (in other words, Chinese numeral). \code{arabic2kansuji()}
function can also convert Arabic numerals in the string to kansuji.
\code{arabic2kansuji_num()} function can convert a vector of only one Arabic
numerals to Kansuji. Use \code{arabic2kansuji_all()} can calculate and convert
Arabic numerals to Kansuji while retaining the original non-Arabic numeral
string.
}
\examples{
arabic2kansuji(2020)
arabic2kansuji(2020, zero = "zero")
arabic2kansuji(c(2019, 2020, 2021))
arabic2kansuji_num(2020)
arabic2kansuji_num((c(2019, 2020, 2021)))
arabic2kansuji_all("This year is 2020, next year is 2021.")
}
