% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalGenHz.R
\name{evalGenHZ}
\alias{evalGenHZ}
\title{Evaluate Generalized Horizon Labels}
\usage{
evalGenHZ(
  obj,
  genhz = GHL(obj, required = TRUE),
  vars,
  non.matching.code = "not-used",
  stand = TRUE,
  trace = FALSE,
  metric = "euclidean"
)
}
\arguments{
\item{obj}{a \code{SoilProfileCollection} object}

\item{genhz}{name of horizon-level attribute containing generalized horizon labels}

\item{vars}{character vector of horizon-level attributes to include in the evaluation}

\item{non.matching.code}{code used to represent horizons not assigned a generalized horizon label}

\item{stand}{standardize variables before computing distance matrix, passed to \code{\link[cluster:daisy]{cluster::daisy()}}}

\item{trace}{verbose output from passed to \code{\link[MASS:isoMDS]{MASS::isoMDS()}}}

\item{metric}{distance metric, passed to \code{\link[cluster:daisy]{cluster::daisy()}}}
}
\value{
a list is returned containing:
\itemize{
\item horizons: \verb{c('mds.1', mds.2', 'sil.width', 'neighbor')}
\item stats: mean and standard deviation \code{vars}, computed by generalized horizon label
\item dist: the distance matrix as passed to \code{\link[MASS:isoMDS]{MASS::isoMDS()}}
}
}
\description{
Data-driven evaluation of generalized horizon labels using nMDS and
silhouette width.
}
\details{
Non-metric multidimensional scaling is performed via \code{\link[MASS:isoMDS]{MASS::isoMDS()}}.
The input distance matrix is generated by \code{\link[cluster:daisy]{cluster::daisy()}} using
(complete cases of) horizon-level attributes from \code{obj} as named in
\code{vars}.

Silhouette widths are computed via \code{\link[cluster:silhouette]{cluster::silhouette()}}. The input
distance matrix is generated by \code{\link[cluster:daisy]{cluster::daisy()}} using (complete cases
of) horizon-level attributes from \code{obj} as named in \code{vars}. Note
that observations with genhz labels specified in \code{non.matching.code}
are removed filtered before calculation of the distance matrix.
}
\seealso{
\code{\link[=get.ml.hz]{get.ml.hz()}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
