% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_apsimx_replacement.R
\name{inspect_apsimx_replacement}
\alias{inspect_apsimx_replacement}
\title{Inspect a replacement component in an .apsimx (JSON) file}
\usage{
inspect_apsimx_replacement(
  file = "",
  src.dir = ".",
  node = NULL,
  node.child = NULL,
  node.subchild = NULL,
  node.subsubchild = NULL,
  node.sub3child = NULL,
  node.string = NULL,
  root = list("Models.Core.Replacements", NA),
  parm = NULL,
  display.available = FALSE,
  digits = 3,
  print.path = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{file}{file ending in .apsimx to be inspected (JSON)}

\item{src.dir}{directory containing the .apsimx file to be inspected; defaults to the current working directory}

\item{node}{specific node to be inspected}

\item{node.child}{specific node child component to be inspected.}

\item{node.subchild}{specific node sub-child to be inspected.}

\item{node.subsubchild}{specific node sub-subchild to be inspected.}

\item{node.sub3child}{specific node sub-sub-subchild to be inspected.}

\item{node.string}{passing of a string instead of the node hierarchy.
Do not use this and also the other node arguments. This argument will
overwrite the other node specifications.}

\item{root}{\sQuote{root} for the inspection of a replacement file (it gives flexibility to inspect other types of files).}

\item{parm}{specific parameter to display}

\item{display.available}{logical. Whether to display available components to be inspected (default = FALSE)}

\item{digits}{number of decimals to print (default 3)}

\item{print.path}{print the path to the inspected parameter (default FALSE)}

\item{verbose}{whether to print additional information, default: TRUE}
}
\value{
table with inspected parameters and values
}
\description{
inspect the replacement componenet of an JSON apsimx file. It does not replace the GUI, but it can save time by quickly checking parameters and values.
}
\details{
This is simply a script that prints the relevant parameters which are likely to need editing. It does not print all information from an .apsimx file.
}
\note{
I need to make some changes in order to be able to handle multiple parameters. At this point, it
might work but it will generate warnings.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
inspect_apsimx_replacement("MaizeSoybean.apsimx", src.dir = extd.dir,
                           node = "Maize", node.child = "Phenology",
                           node.subchild = "ThermalTime", 
                           node.subsubchild = "BaseThermalTime",
                           node.sub3child = "TemperatureResponse") 
}
\dontrun{  
## This function can also be used to inspect more complex APSIM-X files
## For example the 'Factorial' example
ex.dir <- auto_detect_apsimx_examples()
inspect_apsimx_replacement("Factorial", src.dir = ex.dir, 
root = list("Experiment", 1), node = "Base", node.child = "Weather")
}

}
