% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsimx_json.R
\name{edit_apsimx}
\alias{edit_apsimx}
\title{Edit an APSIM-X (JSON) Simulation}
\usage{
edit_apsimx(
  file,
  src.dir = ".",
  wrt.dir = NULL,
  node = c("Clock", "Weather", "Soil", "SurfaceOrganicMatter", "MicroClimate", "Crop",
    "Manager"),
  soil.child = c("Metadata", "Water", "Organic", "Physical", "Analysis", "Chemical",
    "InitialWater", "Sample"),
  manager.child = NULL,
  parm = NULL,
  value = NULL,
  overwrite = FALSE,
  edit.tag = "-edited",
  parm.path = NULL,
  root,
  verbose = TRUE
)
}
\arguments{
\item{file}{file ending in .apsimx to be edited (JSON)}

\item{src.dir}{directory containing the .apsimx file to be edited; defaults to the current working directory}

\item{wrt.dir}{should be used if the destination directory is different from the src.dir}

\item{node}{either \sQuote{Clock}, \sQuote{Weather}, \sQuote{Soil}, 
\sQuote{SurfaceOrganicMatter}, \sQuote{MicroClimate}, \sQuote{Crop}, \sQuote{Manager} or \sQuote{Other}}

\item{soil.child}{specific soil component to be edited}

\item{manager.child}{specific manager component to be edited}

\item{parm}{parameter to be edited}

\item{value}{new values for the parameter to be edited}

\item{overwrite}{logical; if \code{TRUE} the old file is overwritten, a new file is written otherwise}

\item{edit.tag}{if the file is edited a different tag from the default \sQuote{-edited} can be used.}

\item{parm.path}{path to the attribute to edit when node is \sQuote{Other}}

\item{root}{supply the node postion in the case of multiple simulations such as factorials.}

\item{verbose}{whether to print information about successful edit}
}
\value{
(when verbose=TRUE) complete file path to edited .apsimx file is returned as a character string.
As a side effect this function creates a new (JSON) .apsimx file.
}
\description{
This function allows editing of an APSIM-X (JSON) simulation file.
}
\details{
The variables specified by \code{parm} within the .apsimx file specified by \code{file} 
in the source directory \code{src.dir} are edited. The old values are replaced with \code{value}, which
is a list that has the same number of elements as the length of the vector \code{parm}.  The current
.apsimx file will be overwritten if \code{overwrite} is set to \code{TRUE}; otherwise the file
\sQuote{file} \emph{-edited.apsimx} will be created.  If (verbose = TRUE) then the name
 of the written file is returned. The function is similar to the edit_apsim functin in the \sQuote{apsimr}
 package, but with the difference that only some variables (parameters) can be modified.
 
 The function inspect_apsimx is for a quick look from within R. The APSIM GUI provides a more
 complete examination of the .apsimx file
}
\note{
The components that can be edited are restricted becuase this is better in preventing
errors of editing unintended parts of the file. The disadvantage is that there is less flexibility
compared to the similar function in the \sQuote{apsimr} package.
}
\examples{
\dontrun{
## This example will read one of the examples distributed with APSIM-X
## but write to a temporary directory
tmp.dir <- tempdir()

## Edit Bulk density
ex.dir <- auto_detect_apsimx_examples()
bds <- c(1.02, 1.03, 1.09, 1.16, 1.18, 1.19, 1.20)
edit_apsimx("Barley.apsimx", src.dir = ex.dir,
            wrt.dir = tmp.dir,
            node = "Soil",
            soil.child = "Water", 
            parm = "BD", value = bds,
            verbose = FALSE)
## Inspect file
inspect_apsimx("Barley-edited.apsimx", src.dir = tmp.dir,
                node = "Soil", soil.child = "Water")
## To delete the file...
file.remove(paste0(tmp.dir, "/Barley-edited.apsimx"))

## Edit the fertilizer amount in 'Maize.apsimx'
edit_apsimx("Maize.apsimx", src.dir = ex.dir,
             wrt.dir = tmp.dir,
             node = "Manager",
             manager.child = "SowingFertiliser",
             parm = "Amount",
             value = 200, verbose = TRUE)
             
## Make sure it worked
inspect_apsimx("Maize-edited.apsimx", src.dir = tmp.dir, node = "Manager")

## Remove the file
file.remove(paste0(tmp.dir,"/Maize-edited.apsimx"))
}

}
