% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/editAPSIM.R
\name{edit_sim_file}
\alias{edit_sim_file}
\title{Edit an APSIM Module File}
\usage{
edit_sim_file(file, wd = getwd(), var, value, overwrite = FALSE)
}
\arguments{
\item{file}{.xml module file to be edited}

\item{wd}{directory containing the .xml file to be edited; defaults to the current wd}

\item{var}{vector of variables to be edited}

\item{value}{list of new values for the specified variables}

\item{overwrite}{logical; if \code{TRUE} the old file is overwritten, otherwise a new file is written}
}
\value{
complete file path to edited simulation file is returned as a character string
}
\description{
APSIM helper files, such as "Soil.xml", have a different format from .apsim files
and are therefore handled separately
}
\details{
APSIM uses .xml files to dictate how certain processes are carried out.  Similar to
\code{\link{edit_apsim}} this function edits a file that will be used in an APSIM simulation.  Unlike
\code{\link{edit_apsim}} this function edits the .xml simulation files.
The variables specified by \code{var} within the .xml file specified by \code{file}
in the working directory \code{wd} are edited. The old values are replaced with \code{value}, which
is a list that has the same number of elements as the vector \code{var} is long.  The current
.xml file will be overwritten if \code{overwrite} is set to \code{TRUE}; otherwise the file
\emph{file-edited.xml} will be created.  If the file was successfully edited, then the name
 of the written file is returned.
}
\examples{
\dontrun{
#The file I want to edit is called "Soil.xml" which is the the directory "~/APSIM"
simFile <- "Soil.xml"
apsimWd <- "~/APSIM"

#I want to change the potential nitrification and N2O from nitrification
simVar <- c("nitrification_pot", "dnit_nitrf_loss","wfnit_values")

#Change both to absolute values of random N(0,1)
simValue <- list(abs(rnorm(1)), abs(rnorm(1)), c(0,2,2,1))

#Edit Soil.xml without overwriting it
edit_sim_file(file = simFile, wd = apsimWd, var = simVar, value = simValue, overwrite = FALSE)

#Passing an .apsim file to edit_sim_file will give a warning and redirect it to edit_apsim
apsimFile <- "Canopy.apsim"
apsimValue <- list(c(rep(200, 2), rep(300, 9)), 9, "NSW")
apsimVar <- c("SoilWater/Thickness", "SoilOrganicMatter/SoilCN", "State")
edit_sim_file(file = apsimFile, wd = apsimWd, var = apsimVar, value = apsimValue, overwrite = FALSE)
}
}

