% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/editAPSIM.R
\name{edit_apsim}
\alias{edit_apsim}
\title{Edit an APSIM Simulation}
\usage{
edit_apsim(file, wd = getwd(), var, value, overwrite = FALSE)
}
\arguments{
\item{file}{file ending in .apsim to be edited}

\item{wd}{directory containing the .apsim file to be edited; defaults to the current wd}

\item{var}{vector of variables to be edited}

\item{value}{list of new values for the specified variables}

\item{overwrite}{logical; if \code{TRUE} the old file is overwritten, a new file is written otherwise}
}
\value{
complete file path to edited .apsim file is returned as a character string
}
\description{
This function allows you to edit a file ending in ".apsim".
}
\details{
The variables specified by \code{var} within the .apsim file specified by \code{file}
in the working directory \code{wd} are edited. The old values are replaced with \code{value}, which
is a list that has the same number of elements as the length of the vector \code{var}.  The current
.apsim file will be overwritten if \code{overwrite} is set to \code{TRUE}; otherwise the file
\emph{file-edited.apsim} will be created.  The name of the written file is returned.
}
\examples{
\dontrun{
#The file I want to edit is called "Canopy.apsim" which is in the directory "~/APSIM"
apsimFile <- "Canopy.apsim"
apsimWd <- "~/APSIM"

#I want to change the Thickness of the Soilwater, the SoilCN of the SoilOrganicMatter and
#the state at which the simulation is being run.
apsimVar <- c("SoilWater/Thickness", "SoilOrganicMatter/SoilCN", "State")

#Change SoilWater-Thickness to 200,200,300x9
#Change SoilCN to 10
#Change "State" to "NSW"
apsimValue <- list(c(rep(200, 2), rep(300, 9)), 9, "NSW")

#Edit the apsim file without overwriting it
edit_apsim(file = apsimFile, wd = apsimWd, var = apsimVar, value = apsimValue, overwrite = FALSE)

#Run the edited simulation
apsimExe <-"C:/Program Files (x86)/Apsim75-r3008/Model/Apsim.exe"

results <- apsim(apsimExe, apsimWd, files = "Canopy-edited.apsim")

#Passing a simulation file to  edit_apsim will give you a warning and redirect it to edit_sim_file
simFile <- "Soil.xml"
simValue <- list(abs(rnorm(1)), abs(rnorm(1)), c(0,2,2,1))
simVar <- c("nitrification_pot", "dnit_nitrf_loss","wfnit_values")
edit_apsim(file = simFile, wd = apsimWd, var = simVar, value = simValue, overwrite = FALSE)
}
}

