% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_prepareProb.R
\name{apollo_prepareProb}
\alias{apollo_prepareProb}
\title{Checks likelihood}
\usage{
apollo_prepareProb(P, apollo_inputs, functionality)
}
\arguments{
\item{P}{List of vectors, matrices or 3-dim arrays. Likelihood of the model components.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{functionality}{Character. Can take different values depending on desired output of \code{apollo_probabilities}.
\describe{
  \item{"estimate"}{For model estimation, returns probabilities of chosen alternatives.}
  \item{"prediction"}{For model predictions, returns probabilities of all alternatives.}
  \item{"validate"}{Validates input.}
  \item{"zero_LL"}{Return probabilities with all parameters at zero.}
  \item{"conditionals"}{For conditionals, returns probabilities of chosen alternatives.}
  \item{"output"}{Checks that the model is well defined.}
  \item{"raw"}{For debugging, returns probabilities of all alternatives}
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"estimate"}}: Returns only the \code{"model"} component of argument \code{P}.
          \item \strong{\code{"prediction"}}: Returns argument \code{P} without any changes.
          \item \strong{\code{"validate"}}: Returns argument \code{P} without any changes.
          \item \strong{\code{"zero_LL"}}: Returns argument \code{P} without any changes to its content, but gives names the unnamed elements.
          \item \strong{\code{"conditionals"}}: Returns only the \code{"model"} component of argument \code{P}.
          \item \strong{\code{"output"}}: Returns argument \code{P} without any changes to its content, but gives names the unnamed elements.
          \item \strong{\code{"raw"}}: Returns argument \code{P} without any changes.
        }
}
\description{
Checks that likelihoods, i.e. probabilities in the case of choice models, are in the appropiate format to be returned.
}
\details{
This function should be called inside \code{apollo_probabilities}, near the end of it, just before \code{return(P)}.
This function only performs checks on the shape of P, but does not change its values in any way.
}
