% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_el.R
\name{apollo_el}
\alias{apollo_el}
\title{Calculates exploded logit probabilities}
\usage{
apollo_el(el_settings, functionality)
}
\arguments{
\item{el_settings}{List of inputs of the exploded logit model. It shoud contain the following.
\itemize{
 \item alternatives: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}.
 \item avail: Named list of numeric vectors or scalars. Availabilities of alternatives, one element per alternative. Names of elements must match those in \code{alternatives}. Values can be 0 or 1.
 \item choiceVars: List of numeric vectors. Contain choices for each position of the ranking. The list must be ordered with the best choice first, second best second, etc. It will usually be a list of columns from the database.
 \item V: Named list of deterministic utilities . Utilities of the alternatives. Names of elements must match those in \code{alternatives.}
 \item scales: List of vectors. Scale factors of each logit model. Should have one element less than choiceVars. At least one element should be normalized to 1. If omitted, scale=1 for all positions is assumed.
 \item rows: Boolean vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
}}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item "estimate": Used for model estimation.
  \item "prediction": Used for model predictions.
  \item "validate": Used for validating input.
  \item "zero_LL": Used for calculating null likelihood.
  \item "conditionals": Used for calculating conditionals.
  \item "output": Used for preparing output after model estimation.
  \item "raw": Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item "estimate": vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item "prediction": Not applicable.
          \item "validate": Boolean. Returns TRUE if all tests are passed.
          \item "zero_LL": vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
          \item "conditionals": Same as "prediction".
          \item "output": Same as "estimate" but also writes summary of choices into temporary file (later read by \code{apollo_modelOutput}).
          \item "raw": Same as "prediction".
        }
}
\description{
Calculates the probabilities of an exploded logit model and can also perform other operations based on the value of the \code{functionality} argument.
The function calculates the probability of a ranking as a product of logit models with gradually reducing availability, where scale differences can be allowed for.
}
