% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_makeCluster.R
\name{apollo_makeCluster}
\alias{apollo_makeCluster}
\title{Creates cluster for estimation.}
\usage{
apollo_makeCluster(apollo_control, apollo_probabilities, database,
  draws = NA, apollo_randcoeff = NA, apollo_lcpars = NA,
  silent = FALSE)
}
\arguments{
\item{apollo_control}{List of model options.}

\item{apollo_probabilities}{Function. likelihood provided by the user.}

\item{database}{data.frame Data to be used by model. Gets splitted and copied into the cluster.}

\item{draws}{List of draws (numeric arrays). Default is NA. Get splitted and copied into the cluster.}

\item{apollo_randcoeff}{Function. Creates the random coeff or error terms by mixing draws and params. Provided by the user.}

\item{apollo_lcpars}{Function. Used for latent class models. Not implemented yet.}

\item{silent}{Boolean. Default is FALSE.}
}
\value{
Cluster (i.e. an object of class cluster from package parallel)
}
\description{
Creates cluster and loads pieces of the database in each worker.
}
\details{
Internal use only. Called by apollo_estimate before estimation. AT least doubles up memory usage. But during the splitting it uses even more (~250% of the original).
}
