% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{rdrop_annotations}
\alias{rdrop_annotations}
\title{Randomly drop leaf annotations}
\usage{
rdrop_annotations(
  x,
  pcent,
  prob.drop.0 = 0.5,
  informative = getOption("aphylo_informative", FALSE)
)
}
\arguments{
\item{x}{An object of class \link{aphylo}.}

\item{pcent}{Numeric scalar. Proportion of the annotations to remove.}

\item{prob.drop.0}{Numeric scalar. Probability of removing a 0, conversely,
\code{1 - prob.drop.0} is the probability of removing a 1.}

\item{informative}{Logical scalar. If \code{TRUE} (the default) the algorithm drops
annotations only if the number of annotations to drop of either 0s or 1s are
less than the currently available in the data.}
}
\value{
\code{x} with fewer annotations (more 9s).
}
\description{
The function takes an annotated tree and randomly selects leaf nodes to set
annotations as 9 (missing). The function allows specifying a proportion of
annotations to drop, and also the relative probability that has dropping
a 0 with respecto to a 1.
}
\examples{
# The following tree has roughtly the same proportion of 0s and 1s
# and 0 mislabeling.
set.seed(1)
x <- raphylo(200, Pi=.5, mu_d=c(.5,.5), psi=c(0,0))
summary(x)

# Dropping half of the annotations
summary(rdrop_annotations(x, .5))

# Dropping half of the annotations, but 0 are more likely to drop
summary(rdrop_annotations(x, .5, prob.drop.0 = 2/3))

}
