% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_fill}
\alias{ax_fill}
\title{Fill property}
\usage{
ax_fill(
  ax,
  type = NULL,
  colors = NULL,
  opacity = NULL,
  gradient = NULL,
  image = NULL,
  pattern = NULL,
  ...
)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{type}{Whether to fill the paths with solid colors or gradient.
Available options: \code{"solid"}, \code{"gradient"}, \code{"pattern"} or \code{"image"}.}

\item{colors}{Colors to fill the svg paths..}

\item{opacity}{Opacity of the fill attribute.}

\item{gradient}{A list of parameters.}

\item{image}{A list of parameters.}

\item{pattern}{A list of parameters.}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Fill property
}
\note{
See \url{https://apexcharts.com/docs/options/fill/}
}
\examples{
library(dplyr)
data("diamonds", package = "ggplot2")

# Use a pattern to fill bars
apex(
  data = count(diamonds, cut, color),
  mapping = aes(x = color, y = n, fill = cut)
) \%>\% 
  ax_fill(
    type = "pattern", 
    opacity = 1, 
    pattern = list(
      style = c("circles", "slantedLines", "verticalLines", "horizontalLines", "squares")
    )
  )


data("economics", package = "ggplot2")

# Customise gradient
apex(
  data = economics,
  mapping = aes(x = date, y = psavert),
  type = "area"
) \%>\%
  ax_fill(gradient = list(
    enabled = TRUE,
    shadeIntensity = 1,
    inverseColors = FALSE,
    opacityFrom = 0,
    opacityTo = 1,
    stops = c(0, 2000)
  ))
}
