% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readInputClusters.R
\name{readInputRES}
\alias{readInputRES}
\title{Read Input RES time series}
\usage{
readInputRES(
  clusters = NULL,
  opts = simOptions(),
  timeStep = c("hourly", "daily", "weekly", "monthly", "annual"),
  simplify = TRUE,
  parallel = FALSE,
  showProgress = TRUE
)
}
\arguments{
\item{clusters}{vector of RES clusters names for which renewable time series must be read.}

\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}

\item{timeStep}{Resolution of the data to import: hourly (default), daily,
weekly, monthly or annual.}

\item{simplify}{If TRUE and only one type of output is imported then a
data.table is returned. If FALSE, the result will always be a list of class
"antaresData".}

\item{parallel}{Should the importation be parallelized ? (See details)}

\item{showProgress}{If TRUE the function displays information about the progress of the
importation.}
}
\value{
data.table with class "antaresDataTable".
}
\description{
\code{readInputRes} is a function that reads renewable time series from an antares
project. But contrary to \code{\link{readAntares}}, it only reads time series
stored in the input folder, so it can work in "input" mode.
}
\seealso{
\code{\link{setSimulationPath}}, \code{\link{readAntares}},
\code{\link{getAreas}}, \code{\link{getLinks}}
}
