#Copyright © 2016 RTE Réseau de transport d’électricité

#' View the content of an antares output
#'
#' This function displays each element of an \code{antaresData} object in a
#' spreadsheet-like viewer.
#'
#' @param x
#' An object of class \code{antaresData}, generated by the function
#' \code{\link{readAntares}}.
#' @param ...
#' Currently unused
#'
#' @return
#' Invisible NULL.
#' 
#' @examples 
#' \dontrun{
#' setSimulationPath()
#' 
#' areas <-readAntares()
#' viewAntares(areas)
#' 
#' output <- studyAntares(areas="all", links = "all", clusters = "all")
#' viewAntares(output) # Opens three data viewers for each element of output
#' }
#' 
#' @export
#'
#'
viewAntares <- function(x, ...) {
  UseMethod("viewAntares", x)
}

#' @export
viewAntares.default <- function(x, ...) {
  title <- deparse(substitute(x))
  if (is.data.frame(x) && ncol(x) > 100) {
    warning(title, " has ", ncol(x), 
            " columns but the data viewer can only display the 100 columns. ",
            ncol(x) - 100, "columns are masked.")
  }
  View(x, title)
}

#' @export
viewAntares.antaresDataList <- function(x, ...) {
  title <- deparse(substitute(x))
  for (k in names(x)) {
    if (is.data.frame(x[[k]])) View(x[[k]], paste(title, k, sep = "$"))
  }

  invisible(NULL)
}
