% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surplusClusters.R
\name{surplusClusters}
\alias{surplusClusters}
\title{Compute the surplus of clusters}
\usage{
surplusClusters(x, timeStep = "annual", synthesis = FALSE,
  surplusLastUnit = FALSE, clusterDesc = NULL)
}
\arguments{
\item{x}{An \code{antaresData} object created with \code{readAntares}. It must
contain an element \code{clusters} and an element \code{areas} with at
least the column \code{MRG. PRICE}.}

\item{timeStep}{Desired time step for the result.}

\item{synthesis}{If TRUE, average surpluses are returned. Else the function returns surpluses
per Monte-Carlo scenario.}

\item{surplusLastUnit}{Should the surplus of the last unit of a cluster be computed ? If
\code{TRUE}, then \code{x} must have been created with the option
\code{thermalAvailabilities=TRUE} in order to contain the required column
"available units"}

\item{clusterDesc}{A table created with the function \code{\link[antaresRead]{readClusterDesc}}.
If is this parameter is set to \code{NULL} (the default), then the function
attemps to read the needed data in the same study as \code{x}.}
}
\value{
A data.table of class \code{antaresDataTable} with the following columns:
\item{area}{Area name.}
\item{cluster}{Cluster name.}
\item{timeId}{Time id and other time columns.}
\item{variableCost}{
  Proportional costs of production of the cluster

  Formula = marginal cost * production
}
\item{fixedCost}{
  Fixed costs of production of the cluster

  Formula = NODU * fixed cost
}
\item{startupCost}{
  Start up costs of the cluster.
}
\item{surplusPerUnit}{
  Average surplus per unit of the cluster.

  formula = (`MRG. PRICE` * production - opCost - startupCost) / unitcount
}
\item{surplusLastUnit}{
  Surplus of the last unit of the cluster.

  formula = (`MRG. PRICE` * prodLastUnit - opCost / pmax(1, NODU) - startup.cost)
}
\item{totalSurplus}{
  Surplus of all units of the cluster.

  formula = `MRG. PRICE` * production - opCost - startupCost
}
\item{economicGradient}{
  Economic gradient of a cluster. It is equal to
  the surplus per unit divided by the capacity of a unit.

  formula = surplusPerUnit / nominalcapacity
}
}
\description{
This function computes the surplus of clusters of interest. The surplus of a
cluster is equal to its production times the marginal cost of the area it
belongs to minus variable, fixed and startup costs.
}
\examples{
\dontrun{
# Data required by the function:
showAliases("surplusClusters")

mydata <- readAntares(select = "surplusClusters")
surplusClusters(mydata)

# Computing the surplus of the last unit of a cluster requires the additional
# column "availableUnits". To add this column, one has to use parameter
# "thermalAvailabilities = TRUE" in readAntares.

mydata <- readAntares(select = c("surplusClusters", "thermalAvailabilities"))
surplusClusters(mydata, surplusLastUnit = TRUE)

}

}
