% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_stream_permutations.R
\name{obtain_permuted_network_versions}
\alias{obtain_permuted_network_versions}
\title{Function to obtain permuted networks from raw datastream}
\usage{
obtain_permuted_network_versions(
  species_raw,
  temporal_thresh,
  spatial_thresh,
  n_permutations,
  n_cores = 1
)
}
\arguments{
\item{species_raw}{A dataframe consisting of raw GPS observations}

\item{temporal_thresh}{Temporal threshold in minutes}

\item{spatial_thresh}{Spatial threshold}

\item{n_permutations}{Number of permuted versions to obtain}

\item{n_cores}{Number of cores for parallel processing with default 1}
}
\value{
A list of size n_permutations where each element is a network of class igraph obtained by permuting raw datastream
}
\description{
Function to obtain permuted networks from raw datastream
}
\examples{
\donttest{
data(elk_data_2010)
permuted_versions <- obtain_permuted_network_versions(elk_data_2010, 
temporal_thresh = 7, spatial_thresh = 15, n_permutations = 10, n_cores = 2)
}
}
