% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{update_distr_man}
\alias{update_distr_man}
\alias{update_gamma}
\alias{update_exp}
\alias{update_vonmises}
\title{Manually update \code{amt_distr}}
\usage{
update_gamma(dist, beta_sl, beta_log_sl)

update_exp(dist, beta_sl)

update_vonmises(dist, beta_cos_ta)
}
\arguments{
\item{dist}{\verb{[amt_distr]} The tentative distribution to be updated
respective distributions.}

\item{beta_sl}{\verb{[numeric]} \cr The estimate of the coefficient of the step length.}

\item{beta_log_sl}{\verb{[numeric]} \cr The estimate of the coefficient of the log of the step length.}

\item{beta_cos_ta}{\verb{[numeric]} \cr The estimate of the coefficient of cosine of the turning angle.}
}
\description{
Functions to update \code{amt_distr} from iSSF coefficients
}
\details{
These functions are called internally by
\code{\link{update_sl_distr}()} and \code{\link{update_ta_distr}()}.
However, those simple functions assume that the selection-free step-length
and turn-angle distributions are constant (i.e., they do not depend on
covariates). In the case of interactions between movement parameters and
covariates, the user will want to manually access these functions to update
their selection-free movement distributions.
}
\examples{

# Fit an SSF, then update movement parameters.

 #Prepare data for SSF
ssf_data <- deer \%>\%
  steps_by_burst() \%>\%
  random_steps(n = 15) \%>\%
  extract_covariates(sh_forest) \%>\%
  mutate(forest = factor(sh.forest, levels = 1:2,
                    labels = c("forest", "non-forest")),
  cos_ta_ = cos(ta_),
  log_sl_ = log(sl_))

# Check tentative distributions
#    Step length
attr(ssf_data, "sl_")
#    Turning angle
attr(ssf_data, "ta_")

# Fit an iSSF (note model = TRUE necessary for predict() to work)
m1 <- ssf_data \%>\%
  fit_issf(case_ ~ forest * (sl_ + log_sl_ + cos_ta_) +
               strata(step_id_), model = TRUE)

# Update forest step lengths (the reference level)
forest_sl <- update_gamma(m1$sl_,
                          beta_sl = m1$model$coefficients["sl_"],
                          beta_log_sl = m1$model$coefficients["log_sl_"])

# Update non-forest step lengths
nonforest_sl <- update_gamma(m1$sl_,
                             beta_sl = m1$model$coefficients["sl_"] +
                               m1$model$coefficients["forestnon-forest:sl_"],
                             beta_log_sl = m1$model$coefficients["log_sl_"] +
                               m1$model$coefficients["forestnon-forest:log_sl_"])

# Update forest turn angles (the reference level)
forest_ta <- update_vonmises(m1$ta_,
                             beta_cos_ta = m1$model$coefficients["cos_ta_"])

# Update non-forest turn angles
nonforest_ta <- update_vonmises(m1$ta_,
                                beta_cos_ta = m1$model$coefficients["cos_ta_"] +
                                  m1$model$coefficients["forestnon-forest:cos_ta_"])

}
