% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran.R
\name{on_cran}
\alias{on_cran}
\title{Detect CRAN}
\usage{
on_cran(cran_pattern = "_R_", n_cran_envvars = 5L)
}
\arguments{
\item{cran_pattern}{String to match against environment variables.}

\item{n_cran_envvars}{If at least this number of environment variables match
the \code{cran_pattern}, \code{on_cran()} returns \code{TRUE}.}
}
\value{
A logical value
}
\description{
This function detects whether the current R environment is a
CRAN machine or not. It returns \code{FALSE} if the \code{NOT_CRAN} environment
variable used in "github/r-lib" packages like \pkg{devtools} and
\pkg{testthat} is set to "true". If that variable is not set, the function
examines other environment variables typically set on CRAN machines, as
documented in the issue on this packages' GitHub repository at
\url{https://github.com/briandconnelly/ami/issues/14}.
}
\examples{
on_cran()
withr::with_envvar(
  list("NOT_CRAN" = "false", "_R_1" = 1, "_R_2" = 2),
  on_cran(n_cran_envvars = 2L)
)
}
