% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_affine.R
\name{trans_affine}
\alias{trans_affine}
\alias{rotate}
\alias{stretch}
\alias{shear}
\alias{translate}
\alias{reflect}
\title{Apply linear transformation to a long_grid}
\usage{
trans_affine(x, y, ...)

rotate(angle = 0)

stretch(x0 = 0, y0 = 0)

shear(x0 = 0, y0 = 0)

translate(x0 = 0, y0 = 0)

reflect(x0 = 0, y0 = 0)
}
\arguments{
\item{x, y}{The coordinates to transform}

\item{...}{A sequence of transformations}

\item{angle}{An angle in radians}

\item{x0}{the transformation magnitude in the x-direction}

\item{y0}{the transformation magnitude in the x-direction}
}
\description{
This function allows you to calculate linear transformations of coordinates
in a long_grid object. You can either pass in a transformation matrix or a
trans object as produced by \code{ggforce::linear_trans(...)}. The latter makes it
easy to stack multiple transformations into one, but require the ggforce
package.
}
\section{Linear Transformations}{

The following transformation matrix constructors are supplied, but you can
also provide your own 3x3 matrices to \code{translate()}
\itemize{
\item \code{rotate()}: Rotate coordinates by \code{angle} (in radians) around the center
counter-clockwise.
\item \code{stretch()}: Stretches the x and/or y dimension by multiplying it with
\code{x0}/\code{y0}.
\item \code{shear()}: Shears the x and/or y dimension by \code{x0}/\code{y0}.
\item \code{translate()}: Moves coordinates by \code{x0}/\code{y0}.
\item \code{reflect()}: Reflects coordinates through the line that goes through \verb{0, 0}
and \verb{x0, y0}.
}
}

\examples{
grid <- long_grid(seq(1, 10, length.out = 1000), seq(1, 10, length.out = 1000))
grid$trans <- trans_affine(grid$x, grid$y, rotate(pi/3), shear(-2), rotate(-pi/3))
grid$chess <- gen_checkerboard(grid$trans$x, grid$trans$y)

plot(grid, chess)

}
